/**
 * @author student
/*******************************************************************************
 * Copyright (c) 2003 Clearfield Knowledge Solutions.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.k.co.nz/
 *******************************************************************************/
/* * 
 * Copyright: Copyright (c) 2003
 * Company  : Clearfield Knowledge Solutions
 * @author  : Student
 * @version : 1.0
 * Date Created : Jul 8, 2003
 * Title : Validators.CustomerValidator.java
 * Desprition : This Validators class is responsible for checking and validating the 
 * Customer Details
 * */
package Validators;


import JavaBeans.*;
/**
 * @author student
 *
 * This class is being used for validation of a given customer data.
 * 
 */
public class CustomerValidator {
	
	private String message;
	
	
	/**
	 * This method is being used for getting an error message if the 
	 * validation was unsuccessful. 
	 * @return String The message to be displayed.
	 */
	public String getMessage(){
		return message;
	}
	
	/**
	 * Method: setMessage
	 * This method is being used for setting an error message if
	 * the validation is unsuccessful.
	 * @param message The message to be displayed.
	 * @return void
	 */
	public void setMessage(String message){
		this.message = message;
	}
	
	
	/**
	 * This method is being used for validation of customer data.
	 * @param customerData The customer details that are to be validated.
	 * @return boolean Specifies whether the validation was successful.
	 */
	public boolean validate(Customer_Data customerData){
		
		Customer_Data customerdata = customerData;
		String firstName ,lastName, username;
		String prebilling;
		double prebill;
				
		firstName = customerdata.getFirstName();
		lastName = customerdata.getLastName();
		username = customerdata.getUserName();
		prebilling = customerData.getPreBillingAmount();
		
		//check preBilling amount.
		try{
			if(prebilling!=null && prebilling.length()>0){
				prebill = Double.parseDouble(prebilling);	
			}
		}
		catch(Exception ex){
			message = "Pre billing amount is either empty or has invalid characters.";
			return false;
		}
		
//		System.out.println("Customer Validate: userName "+customerData.getUserName());
//		System.out.println("Customer Validate: firstName "+firstName);
//		System.out.println("Customer Validate: lastName "+lastName);
//		System.out.println("Customer Validate: ncbId "+customerdata.getNcbId());
//		System.out.println("Customer Validate: preBillingAmount "+customerData.getPreBillingAmount());
//		System.out.println("Customer Validate: Account "+customerData.getAccount());
		
		//check first name and last name.
		if(firstName == null || lastName == null ){
			message = "Either first name or last name is empty. ";
			return false;
		}
		if(!firstName.matches("^[a-zA-Z/`/'/,/ ///./-]{1,255}+$")){
			message = "First name has invalid characters.";
			return false;
		}
		if(!lastName.matches("^[a-zA-Z/`/'/ ///,/./-]{1,50}+$")){
			message = "Last name has invalid characters.";
			return false;
		}
		//check username.
		if(!username.matches("^[a-zA-Z/0-9/`/'/ ///,/./-]{1,10}+$")){
			message = "User name has invalid characters.";
			return false;
		}
		return true;
	}
}
